from .flexray_fixture import FlexrayFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_flexray_transmitter",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaFlexrayTransmitter(FlexrayFixture):
    def setUp(self):
        self.logger.info("tca_flexray_transmitter starting")

    # Create the test case method that holds the main test steps.
    def test_flexray_transmitter(self):
       
        flx_ch = ChannelFactory().get_flexray_channel(FR_CHANNEL_NAME)

        flx_fr = flx_ch.get_frame(FR_FRAME_ID)

        # Transmit the flexray frame.
        flex_transmit = flx_fr.transmitter.transmit_frame(FR_PAYLOAD)

        sleep(2)

        # Confirm the correct transmission by verifying the boolean return value of transmit_frame().
        # If there are no issues during transmission, the return value should
        # be true.
        self.assertTrue(flex_transmit, Severity.BLOCKER,
                        "Error when sending a flexray message")

    def tearDown(self):
        # Clean up any remaining test resources.
        self.cleanup_all_controllers()
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_flexray_transmitter stopping")
