from .load_burst_injection_fixture import LoadBurstInjectionFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_can_burst_transmission",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCanBurstTransmission(LoadBurstInjectionFixture):
    def setUp(self):
        self.logger.info("tca_can_burst_transmission starting")

    # Create the test case core method that holds the main test steps.
    def test_can_burst_transmission(self):

        frame_list_can = []

        # Prepare CAN burst frames.
        for i in range(0, 255):
            frame_list_can.append(create_burst_can_frame(
                i + 1, [i, 2, 3, 4, 5, 6, 7, 8], False))

        mtf_burst = create_mtf_burst()

        # Configure CAN  burst.
        # Please note that NUMBER_OF_CAN_FRAMES = CAN_BURST_DURATION * CAN_BURST_FREQUENCY.
        mtf_burst.configure_frame_list(CAN_BURST_DURATION,  # duration_ms : the duration of the burst
                                       CAN_BURST_FREQUENCY,  # frequency : burst frequency (frames per second)
                                       [CAN_CHANNEL_NAME],  # channel_list : a list of channel names to send the burst on
                                       False,  # stop_on_error : whether a transmission error should abort the burst
                                       frame_list_can)  # frames : a list of frames to send

        # Start listening on the CAN channel.
        self.bus_manager.bus_listener(
            CAN_CHANNEL_NAME, BusType.CAN).start_listening()

        # Start transmitting the burst.
        mtf_burst.transmit()

        sleep(2)

        # Stop listening on the CAN channel.
        self.bus_manager.bus_listener(
            CAN_CHANNEL_NAME, BusType.CAN).stop_listening()

        # Get the listener queue that contains CAN frames.
        message_queue = self.bus_manager.bus_listener(
            CAN_CHANNEL_NAME, BusType.CAN).get_queue()

        # Clears burst configuration.
        mtf_burst.clear()

        # Check that the listener queue size equals NUMBER_OF_CAN_FRAMES.
        self.assertEqual(message_queue.qsize(), 
                         NUMBER_OF_CAN_FRAMES,
                         Severity.BLOCKER,
                         "Number of captured frame is not as expected")

    def tearDown(self):
        self.logger.info("tca_can_burst_transmission stopping")

