"""Module for helper functions and group-wide utilities"""
from time import sleep
import subprocess
from mtf.proto_common import EthProtocolType
from mtf.libs.mtf_pybinder import mtf_someip_filter,mtf_ipv4_layer_filter,mtf_udp_layer_filter,mtf_eth_app_layer_filter,mtf_eth_protocol_type


def get_current_ipv4(adapter):
    output = subprocess.check_output(f'netsh interface ip show address name="{adapter}"', shell=True, text=True)
    for line in output.splitlines():
        if "IP Address" in line or "IP Address:" in line:
            return line.split(":")[-1].strip()
    return None

def change_ip(ip, adapter, ipv6=None):
    current_ipv4 = get_current_ipv4(adapter)
    if current_ipv4 != ip:
        print(f"Changing IPv4 from {current_ipv4} to {ip}")
        change_ipv4 = f'netsh interface ip set address name="{adapter}" static {ip} 255.255.0.0'
        subprocess.call(change_ipv4.split())
    else:
        print("IPv4 already set to desired value. Skipping.")

    sleep(2)

def create_someip_filter(ip_src,service_id,method_id,msgType,returnCode):
    ipv4_layer_filter = mtf_ipv4_layer_filter()
    ipv4_layer_filter.ip_srcs = ip_src

    udp_layer_filter = mtf_udp_layer_filter()
    udp_layer_filter.prev_layer_filter = ipv4_layer_filter

    eth_app_layer_filter = mtf_eth_app_layer_filter()
    eth_app_layer_filter.app_layer_protocol_type = mtf_eth_protocol_type.SOME_IP
    eth_app_layer_filter.prev_layer_filter = udp_layer_filter

    someip_filters = mtf_someip_filter()
    someip_filters.services_ids = service_id
    someip_filters.methods_ids = method_id
    someip_filters.msg_type = msgType
    if returnCode is not None:
        someip_filters.return_code = returnCode
    someip_filters.prev_layer_filter = eth_app_layer_filter

    return someip_filters
