from .network_nodes_control_fixture import NetworkNodesControlFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_start_stop_ethernet_simulation",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaStartStopEthernetSimulation(NetworkNodesControlFixture):

    # Create setUp() method.
    def setUp(self):
        self.logger.info("tca_start_stop_ethernet_simulation starting")

    # Create the tearDown() method.
    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_start_stop_ethernet_simulation stopping")

    # Create the test case core method that holds the main test steps.
    def test_start_stop_ethernet_simulation(self):

        # Set the IP address of the sender Ethernet channel to IP_15.
        change_ip(IP_15, ETH_SENDER_CH)

        # Start an Ethernet simulation for ECU_3.
        start_sim_status = tfs_instance.start_ethernet_simulation(ECU_3)

        sleep(2)

        # Stop the Ethernet simulation for ECU_3.
        stop_sim_status = tfs_instance.stop_ethernet_simulation(ECU_3)

        # Verify that both starting and stopping the simulation were successful.
        self.assertTrue(
            start_sim_status and stop_sim_status,
            Severity.BLOCKER,
            "The Ethernet simulation did not start or stop correctly."
        )