from .e2e_fixture import E2eFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_apply_faulty_alive",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaApplyFaultyAlive(E2eFixture):

    # Create setUp() method.
    def setUp(self):
        self.logger.info("tca_apply_faulty_alive starting")

    # Create the tearDown() method.
    def tearDown(self):
        # Clean up any remaining test resources.
        self.cleanup_all_controllers()
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_apply_faulty_alive stopping")

# Create the test case core method that holds the main test steps.
    def test_apply_faulty_alive(self):
        self.legacy_frame(CHANNEL_NAME, FRAME_ID).start_transmission()

        self.legacy_pdu(
            CHANNEL_NAME,
            FRAME_ID,
            PDU_NAME).apply_faulty_halt_alive_counter(True)
        sleep(1)

        self.can_frame_listener(
            CHANNEL_NAME,
            FRAME_ID).start_listening(
            silent_mode=True)
        sleep(2)

        self.can_frame_listener(CHANNEL_NAME, FRAME_ID).stop_listening()

        frames = self.can_frame_listener(CHANNEL_NAME, FRAME_ID).get_queue()

        expected_corrupt_alive = []

        for frame in frames.queue:
            expected_corrupt_alive.append(frame.payload[1] & 0XF)

        for alive in range(len(expected_corrupt_alive) - 1):
            self.assertEqual(expected_corrupt_alive[alive], 
                             expected_corrupt_alive[alive + 1],
                             Severity.BLOCKER,"corrupt_alive length is wrong")
        
        self.assertNotEqual(len(expected_corrupt_alive), 0, Severity.BLOCKER,"corrupt_alive length is wrong")
