from .bus_errors_and_events_fixture import BusErrorAndEventFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_flexray_listener_with_error",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaFlexrayListenerWithError(BusErrorAndEventFixture):

    # Create setUp() method.
    def setUp(self):
        self.logger.info("tca_flexray_listener_with_error starting")

    # Create the tearDown() method.
    def tearDown(self):
        # Clean up any remaining test resources.
        self.cleanup_all_controllers()
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_flexray_listener_with_error stopping")

    # Create the test case core method that holds the main test steps.
    def test_flexray_listener_with_error(self):

        flexray_listener = self.bus_manager.bus_listener(FR_CM_CHANNEL, 
                                                         FLEXRAY_TYPE)
        
        # Start the listener on the CM Flexray channel.
        flexray_listener.start_listening(silent_mode=True, 
                                         flags=INCLUDE_FRAMES_WITH_ERROR)
        
        # Start the transmission of two Flexray errors.
        transmit_packet([HEADER_CRC_FR_ERR, FRAME_CRC_FR_ERR])

        flexray_listener.stop_listening()

        fr_queue_size = flexray_listener.get_queue().qsize()

        # Check that the number of Rx frames captured by the listener 
        # is equal to EXPECTED_NBR_FR_ERR_FRAMES.
        # Here we divided the number by 2 to only get the Rx frames without the Tx ones.
        self.assertEqual(fr_queue_size/2,
                         EXPECTED_NBR_FR_ERR_FRAMES,
                         Severity.BLOCKER,
                         "Number of captured frame is not as expected")