from .signal_last_value_fixture import SignalLastValueFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .config import *


@metadata(
    tc_id="tca_get_last_signal_value",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaGetLastSignalValue(SignalLastValueFixture):

    # Create setUp() method.
    def setUp(self):
        self.logger.info("tca_check_signal_value starting")

    # Create the tearDown() method.
    def tearDown(self):
        self.legacy_frame(CAN_CHANNEL_NAME_C1, LEGACY_FRAME_ID).stop_transmission()
        # Clean up any remaining test resources.
        self.cleanup_all_controllers()
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_check_signal_value stopping")

    # Create the test case core method that holds the main test steps.
    def test_get_last_signal_value(self):

        self.legacy_frame(CAN_CHANNEL_NAME_C1, LEGACY_FRAME_ID).start_transmission()

        self.legacy_signal(
            CAN_CHANNEL_NAME_C1,
            LEGACY_FRAME_ID,
            LEGACY_SIGNAL_NAME).start_observer(
            False,
            True)

        self.signal_controller.set_signal_raw_value(
            CAN_CHANNEL_NAME_C1, LEGACY_FRAME_ID, LEGACY_SIGNAL_NAME, SIGNAL_SET_RAW_VALUE)

        sleep(0.5)

        actual_value = self.legacy_signal(
            CAN_CHANNEL_NAME_C1,
            LEGACY_FRAME_ID,
            LEGACY_SIGNAL_NAME).check_value(
            signal_value=SIGNAL_SET_RAW_VALUE,
            comparision=COMPARISION_TYPE,
            logical_operation=LOGICAL_OPERATION)

        self.legacy_signal(CAN_CHANNEL_NAME_C1, LEGACY_FRAME_ID, LEGACY_SIGNAL_NAME).stop_observer(True)

        self.assertTrue(actual_value, Severity.BLOCKER,
                        "The CAN signal was not set correctly.")