from .signal_last_value_fixture import SignalLastValueFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_check_ethernet_reception",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCheckEthernetReception(SignalLastValueFixture):
    def setUp(self):
        self.logger.info("tca_check_ethernet_reception starting")

    def test_check_ethernet_reception(self):

        # Start an ethernet simulation by ecu name.
        tfs_instance.start_ethernet_simulation(ECU_NAME)
        sleep(1)

        # Start an ethernet observer for npdu.
        tfs_instance.start_ethernet_observer(ETHERNET_MSG_PATH)
        sleep(1)

        # Check ethernet message reception for npdu.
        is_received_ethernet = tfs_instance.check_ethernet_reception(
            ETHERNET_MSG_PATH, True)
        sleep(1)

        # Stop the ethernet observer for npdu.
        tfs_instance.stop_ethernet_observer(ETHERNET_MSG_PATH)

        # Stop the ethernet simulation.
        tfs_instance.stop_ethernet_simulation(ECU_NAME)

        # Check that the 'is_received_ethernet' variable equals True.
        # 'is_received_ethernet' is the return value
        # of the check_ethernet_reception() method.
        self.assertTrue(is_received_ethernet, Severity.BLOCKER,
                        "The message was not received.")

    # Create the tearDown() method.
    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_check_ethernet_reception stopping")