from .signal_last_value_fixture import SignalLastValueFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *

@metadata(
    tc_id="tca_check_ethernet_cyclic_repetition",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCheckEthernetCyclicRepetition(SignalLastValueFixture):

    # Create setUp() method.
    def setUp(self):
        self.logger.info("Setup 'check ethernet cyclic repetition' test case")

    # Create the tearDown() method.
    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("Tear down 'check ethernet cyclic repetition' test case")

    # Create the test case core method that holds the main test steps.
    def test_check_ethernet_cyclic_repetition(self):

        # Start an ethernet simulation by ecu name.
        tfs_instance.start_ethernet_simulation(ECU_NAME)

        sleep(2)

        # Start an ethernet observer for npdu.
        tfs_instance.start_ethernet_observer(ETHERNET_MSG_PATH)

        sleep(2)

        # Check ethernet cyclic repetition for npdu.
        cyclicity = tfs_instance.check_ethernet_cyclic_repetition(
            ETHERNET_MSG_PATH, CYCLE, CYCLE_DEVIATION, NB_REPETITION, True)

        sleep(2)

        # Stop the ethernet observer for npdu.
        tfs_instance.stop_ethernet_observer(ETHERNET_MSG_PATH)

        # Stop the ethernet simulation.
        tfs_instance.stop_ethernet_simulation(ECU_NAME)

        # Check that the 'cyclicity' variable equals True.
        # 'cyclicity' is the return value
        # of the check_ethernet_cyclic_repetition() method.
        self.assertTrue(cyclicity, Severity.BLOCKER,
                        "The message does not respect the required cyclicity.")
