from .io_fixture import IoFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *

@metadata(
    tc_id="tca_set_resistance_value",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaSetIoResistanceValue(IoFixture):

    # This method will be executed just before
    # the test case core method execution.
    def setUp(self):
        self.logger.info("tca_set_resistance_value starting")

    # This method will be executed just after
    # the test case core method execution.
    def tearDown(self):
        self.logger.info("tca_set_resistance_value stopping")

    # Create the test case core method that holds the main test steps.
    def test_set_io_resistance_value(self):

        resistance = self.io_controller.io_set_resistance(IO_CH_3,
                                                          200)
        self.assertTrue(resistance,
                        Severity.BLOCKER,
                        "An issue occured while trying to set a resistance value")