from .frame_last_payload_fixture import FrameLastPayloadFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .config import *
from .helper import *


@metadata(
    tc_id="tca_get_someip_member_latest_value",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaGetSomeipMemberLatestValue(FrameLastPayloadFixture):

    # Create setUp() method.
    def setUp(self):
        self.logger.info("tca_get_someip_member_latest_value starting")

    # Create the tearDown() method.
    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_get_someip_member_latest_value stoping")

    def test_get_someip_member_latest_value(self):

        # Change the IP address of the sender Ethernet channel to IP_57.
        change_ip(IP_57, ETH_SENDER_CH)

        # Change the IP address of the sender Ethernet channel to IP_64.
        change_ip(IP_64, ETH_RECEIVER_CH)

        tfs_instance.start_ethernet_simulation(ECU_4)

        tfs_instance.start_ethernet_simulation(ECU_2)
        sleep(1)

        value_set_check = tfs_instance.set_ethernet_network(
            ECU_4_MEMBER_PATH,
            ECU_4_MEMBER_PARAM)
        self.assertTrue(value_set_check, Severity.BLOCKER,"someip event value was set")        
        sleep(1)

        event_last_value = tfs_instance.get_someip_last_value(ECU_4_MEMBER_PATH)
        sleep(0.1)

        self.assertEqual(event_last_value, 2, Severity.BLOCKER,"someip event last value is not as expected")