from .frame_last_payload_fixture import FrameLastPayloadFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .config import *
from .helper import *

@metadata(
    tc_id="tca_get_npdu_last_value",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaGetNpduLastValue(FrameLastPayloadFixture):

    # Create setUp() method.
    def setUp(self):
        self.logger.info("tca_get_npdu_last_value starting")

    # Create the tearDown() method.
    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_get_npdu_last_value stopping")

    def test_get_npdu_last_value(self):

        # Change the IP address of the sender Ethernet channel to IP_98.
        change_ip(IP_98, ETH_SENDER_CH)

        # Start the Ethernet simulation for ECU_1.
        tfs_instance.start_ethernet_simulation(ECU_1)

        sleep(0.5)

        # Configure the Ethernet network parameters using a predefined path and parameter list.
        tfs_instance.set_ethernet_network(
            ETHERNET_NETWORK_PATH_ECU_1, # Path to an NPDU Ethernet message of ECU_1
            ETHERNET_NETWORK_PARAM_LIST_ECU_1
        )

        sleep(0.5)

        # Retrieve the last NPDU value from the given path.
        data = tfs_instance.get_npdu_last_value(NPDU_PATH)

        # Verify that the captured NPDU value matches the expected data.
        self.assertEqual(
            data,
            EXPECTED_NPDU_DATA,
            Severity.BLOCKER,
            f"Data mismatch expected: {EXPECTED_NPDU_DATA} but got: {data}"
        )

        # Stop the Ethernet simulation for ECU_1 to clean up.
        tfs_instance.stop_ethernet_simulation(ECU_1)