from .frame_last_payload_fixture import FrameLastPayloadFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .config import *
from .helper import *


@metadata(
    tc_id="tca_get_frame_last_value",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaGetFrameLastValue(FrameLastPayloadFixture):
    def setUp(self):
        self.logger.info("tca_get_frame_last_value starting")

    # Create the test case core method that holds the main test steps.
    def test_get_frame_last_value(self):

        # Clear message buffer.
        self.legacy_frame(CAN_CHANNEL_NAME_C1, LEGACY_FRAME_ID).clear_buffer()

        # Start the transmission of the specified frame.
        self.legacy_frame(CAN_CHANNEL_NAME_C1, LEGACY_FRAME_ID).start_transmission()

        # Start the observer on the specified frame while getting only the packets on change.
        self.legacy_frame(CAN_CHANNEL_NAME_C1, LEGACY_FRAME_ID).start_observer(on_change=True)
        sleep(0.1)

        # Set the raw value of the specified signal with the value SIGNAL_SET_RAW_VALUE.
        self.signal_controller.set_signal_raw_value(
            CAN_CHANNEL_NAME_C1, LEGACY_FRAME_ID, LEGACY_SIGNAL_NAME, SIGNAL_SET_RAW_VALUE)
        sleep(0.1)

        # Get the last value of the frame.
        actual_last_value = self.legacy_frame(
            CAN_CHANNEL_NAME_C1, LEGACY_FRAME_ID).get_last_value()
        
        # Stop the observer.
        self.legacy_frame(CAN_CHANNEL_NAME_C1, LEGACY_FRAME_ID).stop_observer(get_values=True)
        
        # Stop the transmitter.
        self.legacy_frame(CAN_CHANNEL_NAME_C1, LEGACY_FRAME_ID).stop_transmission()

        self.assertEqual(
            actual_last_value,
            EXPECTED_FRAME_LAST_VALUE,
            Severity.BLOCKER,
            "Signal raw value was not set")

    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_get_frame_last_value stopping")