"""Module for helper functions and group-wide utilities"""
import subprocess
from time import sleep
from mtf.test_features_sim.test_features_controller import TestFeaturesSim

# Create an instance of the TestFeaturesSim class, which allows control of test simulations.
tfs_instance = TestFeaturesSim()

def get_current_ipv4(adapter):
    output = subprocess.check_output(f'netsh interface ip show address name="{adapter}"', shell=True, text=True)
    for line in output.splitlines():
        if "IP Address" in line or "IP Address:" in line:
            return line.split(":")[-1].strip()
    return None

def change_ip(ip, adapter, ipv6=None):
    current_ipv4 = get_current_ipv4(adapter)
    if current_ipv4 != ip:
        print(f"Changing IPv4 from {current_ipv4} to {ip}")
        change_ipv4 = f'netsh interface ip set address name="{adapter}" static {ip} 255.255.0.0'
        subprocess.call(change_ipv4.split())
    else:
        print("IPv4 already set to desired value. Skipping.")

    sleep(2)