from .flexray_fixture import FlexrayFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_capture_flexray_frames",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCaptureFlexrayFrames(FlexrayFixture):
    def setUp(self):
        self.logger.info("tca_capture_flexray_frames starting")

    # Create the test case method that holds the main test steps.
    def test_capture_flexray_frames(self):

        flx_ch_following = ChannelFactory().get_flexray_channel(FR_CHANNEL_2)

        flx_ch_leading = ChannelFactory().get_flexray_channel(FR_CHANNEL_1)

        flx_fr_tr = flx_ch_leading.get_frame(FR_FRAME_ID)

        # Start listening on the flexray channel.
        flx_ch_following.listener.start_listening(silent_mode=True)

        # Transmit the flexray frame.
        flx_fr_tr.transmitter.transmit_frame(FR_PAYLOAD)

        sleep(1)

        # Stop listening on the flexray channel
        flx_ch_following.listener.stop_listening()

        q = flx_ch_following.listener.get_queue()

        # Confirm that the queue is not Null object,
        # meaning there is no error in creating the queue.
        self.assertTrue(q is not None, Severity.BLOCKER,
                        "Error when listening to flexray bus")

        # Confirm that queue is not empty meaning messages are received.
        self.assertTrue(len(q.queue)>0, Severity.BLOCKER,
                        "Flexray frame is not received")

        event = q.queue[0]

        self.assertTrue(event.channel_name == FR_CHANNEL_2, Severity.BLOCKER,
                        "Wrong captured channel_name")
        
        # Frame id includes the slot id, the cycle and the repetition. 
        # We will extract the slot id.
        slot_id = event.frame_id & 0xffff

        self.assertTrue(slot_id == 5, Severity.BLOCKER,
                        "Wrong captured slot_id")

    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_capture_flexray_frames stopping")