from .can_fixture import CanFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_capture_can_tp_frames",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCaptureCanTpFrames(CanFixture):
    def setUp(self):
        self.logger.info("tca_capture_can_tp starting")

    # Create the test case method that holds the main test steps.
    def test_capture_can_tp_frames(self):
        
        # Create two instances of the CanTP class and configure them with the 
        # required parameters.Certain parameters values must be inverted 
        # between the sender and receiver (e.g.,RX and TX frame IDs,or source 
        # and target addresses) to properly establish communication.
        can_sender= CanTp()
        
        can_receiver= CanTp()
        
        can_sender.Configure(CAN_CM_CHANNEL_1,
                             RX_FRAME_ID,
                             TX_FRAME_ID,
                             CAN_PROTOCOL_TYPE,
                             PDU_LENGTH,
                             PADDING_VALUE,
                             FLOW_TIMEOUT,
                             source_address=SOURCE_ADDRESS,
                             target_address=TARGET_ADDRESS)
        
        can_receiver.Configure(CAN_CM_CHANNEL_2,
                               TX_FRAME_ID,
                               RX_FRAME_ID,
                               CAN_PROTOCOL_TYPE,
                               PDU_LENGTH,
                               PADDING_VALUE,
                               FLOW_TIMEOUT,
                               source_address=TARGET_ADDRESS,
                               target_address=SOURCE_ADDRESS)

        # Transmit the can tp frame with payload length less than 8 bytes.
        can_sender.send(CAN_PAYLOAD)

        sleep(1.5)
        
        # Transmit the can tp frame with payload length more than 8 bytes
        # (14 bytes in our example).
        can_sender.send(EXTENDED_CAN_PAYLOAD)
        
        sleep(1.5)
        
        can_tp_queue = can_receiver.get_can_tp_queue()
        
        # The CanTP queue returns each message as a dict with the 
        # complete payload (without segmentation). Since there are 
        # two transmissions, the queue will contain two distinct CAN messages.
        self.assertTrue(len(can_tp_queue)==2, 
                        Severity.BLOCKER,
                        "can tp queue list is empty")
        
        # Verify that all messages received have the same 
        # frame id and target address, as they originate 
        # from the same communication flow (sender to receiver).
        for can_msg in can_tp_queue:

            self.assertEqual(can_msg["frame_id"],
                             TX_FRAME_ID,
                             Severity.BLOCKER,
                             "wrong frame id received")
            
            self.assertEqual(can_msg["targert_address"],
                             TARGET_ADDRESS,
                             Severity.BLOCKER,
                             "wrong target address received")
            
        # Verify that the first payload received correspend to 
        # the first transmitted payload.
        self.assertEqual(can_tp_queue[0]["payload"],
                         CAN_PAYLOAD,
                         Severity.BLOCKER,
                        "wrong can payload received") 
        
        # Verify that the second payload received correspond to the 
        # extended data transmitted.
        # The can_tp_queue.recv() method returns only the payload list 
        # from the last dict stored in the can_tp_queue.
        self.assertTrue(can_tp_queue[1]["payload"] == can_receiver.recv() == EXTENDED_CAN_PAYLOAD,
                        Severity.BLOCKER,
                        "wrong extended can payload is received")
            
        can_sender.close()
        
        can_receiver.close()

    def tearDown(self):
        # Clean up any remaining test resources.
        self.cleanup_all_controllers()
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_capture_can_tp_frames stopping")