from .can_fixture import CanFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .config import *
from .helper import *


@metadata(
    tc_id="tca_capture_can_frames_using_callback",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCaptureCanFramesUsingCallback(CanFixture):
    def setUp(self):
        self.logger.info("tca_capture_can_frames_using_callback starting")

    def test_capture_can_frames_using_callback(self):

        # Start the listener with the specified channel name and frame id.
        self.can_frame_listener(
            CAN_CHANNEL_NAME_C1,
            CAN_FRAME_ID).start_listening(
                callback=callback,
                silent_mode=False,
                direction=TX_DIR)

        # Transmit a frame according tothe specified channel name, frame id and payload.
        self.bus_manager.bus_transmitter(BUS_CAN_TYPE).transmit_frame(
            CAN_CHANNEL_NAME_C1, 
            CAN_FRAME_ID, 
            CAN_PAYLOAD)
        sleep(1)

        # Stop the listener.
        self.can_frame_listener(CAN_CHANNEL_NAME_C1,CAN_FRAME_ID).stop_listening() 
        sleep(0.5)   

        self.assertTrue(len(actual_list)!=0, Severity.BLOCKER,"Actual can message list is empty")

        self.assertTrue(actual_list==CAN_EXPECTED_DICT, Severity.BLOCKER,"Captured can message doesn't match the expected one")

    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_capture_can_frames_using_callback stopping")