"""Module for group-wide constant values"""
from .helper import Direction, BusType, CanProtocol
CAN_FD_CHANNEL_NAME = 'B1_CAN_FD'
CAN_FD_FRAME_ID = 0x17
CAN_FD_PAYLOAD = [0x1, 0x2, 0x3, 0x4, 0x5, 0x6,0x7, 0x8, 0x9, 0x10, 0x11, 0x12]

CAN_CHANNEL_NAME = 'B1_CAN'
CAN_FRAME_ID = 21
CAN_PAYLOAD = [0x1, 0x2, 0x3, 0x48]
CAN_CHANNEL_NAME_C1 = 'CLUSTER1'
CAN_EXPECTED_DICT = [{'channel_name': 'CLUSTER1', 'frame_id': 21, 'payload': [1, 2, 3, 72], 'payload_length': 4, 'direction': 2}]
TX_DIR = Direction.Tx
BUS_CAN_TYPE = BusType.CAN

CAN_CM_CHANNEL_1 = "Can_Ch_1"
CAN_CM_CHANNEL_2 = "Can_Ch_2"
RX_FRAME_ID = 0x16
TX_FRAME_ID = 0x17
CAN_PROTOCOL_TYPE = CanProtocol.CAN
PDU_LENGTH = 8
PADDING_VALUE = 255
FLOW_TIMEOUT = 200
EXTENDED_CAN_PAYLOAD = list(range(0, 14))
SOURCE_ADDRESS = 0x77
TARGET_ADDRESS = 0x66

# This list represents a segmented CAN-TP message divided into three frames:
# - The first frame(index 0x10) indicates a total payload length of 14 bytes 
#   and contains the first 5 bytes of application data.
# - The consecutive frame (index 0x21) carries the next 6 bytes of data.
# - The final frame (index 0x22) includes the remaining data, followed by 
#   three padding bytes (0xFF) to reach a total payload length of 8 bytes.
CAN_TP_EXPECTED_LIST=[{'channel_name': "Can_Ch_2", 'frame_id': '0x17', 'payload': ['66', '10', 'e', '0', '1', '2', '3', '4'], 'payload_length': 8}, 
                      {'channel_name': "Can_Ch_2", 'frame_id': '0x17', 'payload': ['66', '21', '5', '6', '7', '8', '9', 'a'], 'payload_length': 8}, 
                      {'channel_name': "Can_Ch_2", 'frame_id': '0x17', 'payload': ['66', '22', 'b', 'c', 'd', 'ff', 'ff', 'ff'], 'payload_length': 8}]
