from .signals_listener_fixture import SignalsListenerFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .config import *
from .helper import *


@metadata(
    tc_id="tca_capture_signal",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCaptureSignal(SignalsListenerFixture):

    # Create setUp() method.
    def setUp(self):
        self.logger.info("tca_capture_signal starting")

    # Create the tearDown() method.
    def tearDown(self):

        self.legacy_frame(CLUSTER_NAME, FRAME_ID_1).stop_transmission()
        # Clean up any remaining test resources.
        self.cleanup_all_controllers()
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_capture_signal stopping")

    # Create the test case core method that holds the main test steps.
    def test_capture_signal(self):


        # Start the transmission of the specified frame
        self.legacy_frame(CLUSTER_NAME, FRAME_ID_1).start_transmission()

        # Start the observer on the specified frame and signal
        # Since the second parameter 'is_physical' == True,
        # it will return only physical values
        self.legacy_signal(
            CLUSTER_NAME,
            FRAME_ID_1,
            SIGNAL_NAME_1).start_observer(
            True,
            True)
        
        # Set the physical signal value with a first_value
        self.signal_controller.set_signal_physical_value(
            CLUSTER_NAME, FRAME_ID_1, SIGNAL_NAME_1, FIRST_SET_VALUE)
        sleep(0.5)

        # Set the raw signal value with a second_value
        # Since the compu_method of this signal is identical, 
        # the physical value will be the same as the raw one.
        self.signal_controller.set_signal_raw_value(
            CLUSTER_NAME, FRAME_ID_1, SIGNAL_NAME_1, SECOND_SET_VALUE)
        sleep(0.5)

        # Get the buffer of the observed signals
        get_buffer = self.legacy_signal(
            CLUSTER_NAME, FRAME_ID_1, SIGNAL_NAME_1).get_buffer()

        # Stop the observer
        self.legacy_signal(CLUSTER_NAME, FRAME_ID_1, SIGNAL_NAME_1).stop_observer(True)

        # Create a list of values we get through the observer
        buffer_list = []
        for buffer_element in get_buffer:
            buffer_list.append(buffer_element[1])
        
        self.assertEqual(buffer_list, [FIRST_SET_VALUE, SECOND_SET_VALUE], Severity.BLOCKER,
                        "Signal values in the buffer don't match the set values")
