from .lin_fixture import LinFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_lin_transmitter",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaLinTransmitter(LinFixture):
    def setUp(self):
        self.logger.info("tca_lin_transmitter starting")

    # Create the test case method that holds the main test steps.
    def test_lin_transmitter(self):

        lin_ch = ChannelFactory().get_lin_channel(LIN_CHANNEL_NAME)

        lin_fr = lin_ch.get_frame(LIN_FRAME_ID)

        # Transmit a lin frame.
        lin_transmit = lin_fr.transmitter.transmit_frame(LIN_PAYLOAD)

        sleep(2)

        # Confirm the correct transmission by verifying the boolean return value 
        # of transmit_frame().
        # If there are no issues during transmission, the return value should be true.
        self.assertTrue(lin_transmit, Severity.BLOCKER,
                        "Error when sending a lin message")

    def tearDown(self):
        # Clean up any remaining test resources.
        self.cleanup_all_controllers()
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_lin_transmitter stopping")