from .can_fixture import CanFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_can_fd_transmitter",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCanFdTransmitter(CanFixture):
    def setUp(self):
        self.logger.info("tca_can_fd_transmitter starting")

    # Create the test case core method that holds the main test steps.
    def test_can_fd_transmitter(self):

        can_fd_ch = ChannelFactory().get_can_channel(CAN_FD_CHANNEL_NAME, True)

        # Retrieves the desired can frame object associated with the 
        # frame_id.
        can_fd_fr = can_fd_ch.get_frame(CAN_FD_FRAME_ID)

        # Transmit the can fd frame.
        can_fd_transmit = can_fd_fr.transmitter.transmit_frame(CAN_FD_PAYLOAD)

        sleep(2)

        # Confirm the correct transmission by verifying the boolean return value of transmit_frame().
        # If there are no issues during transmission, the return value should
        # be true.
        self.assertTrue(can_fd_transmit, Severity.BLOCKER,
                        "Error when sending a can fd message")

    def tearDown(self):
        # Clean up any remaining test resources.
        self.cleanup_all_controllers()
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_can_fd_transmitter stopping")