from time import sleep
from .interception_fixture import InterceptionFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *

@metadata(
    tc_id="tca_flexray_with_interception_function",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaFlexrayWithInterceptFunction(InterceptionFixture):
    def setUp(self):
        self.logger.info("tca_flexray_with_interception_function starting")

    # Create the test case method that holds the main test steps.
    def test_flexray_set_interception_function(self):
        
        # This function (change_felxray) will be invoked before sending the frame, 
        # allowing the payload to be modified using the set_interception_function.
        set_function=self.flexray_channel(FR_CHANNEL_2).set_interception_function( change_felxray)
       
        # Verify that the interception function was set successfully.
        self.assertTrue(set_function,
                        Severity.BLOCKER,
                        "set_function did not work properly.") 
        
        # Send the frame in slot 5 on the second cycle of every 8-cycle interval.
        self.flexray_channel(FR_CHANNEL_2).send_frame(FlexRayDataFrame(frame_id=FLEXRAY_FRAME_ID,
                                                                       payload=FLEXRAY_PAYLOAD,
                                                                       com_channel=COMMUNICATION_CHANNEL ,
                                                                       transmission_mode=TRANSMISSION_MODE,
                                                                       error_flags=0))
        
        self.flexray_channel(FR_CHANNEL_1).start_listening()
        
        sleep(2)
        
        self.flexray_channel(FR_CHANNEL_1).stop_listening()
        
        fr_queue=self.flexray_channel(FR_CHANNEL_1).get_history()  
       
        nbr_packet_with_expeted_id = 0
        
        # Iterate over all received frames in the queue.
        for fr_msg in fr_queue:
    
              # Extract the current cycle number from the upper bits of frame_id.
              current_cycle = (fr_msg.frame_id >> 32) & 0xff
             
              # Extract the slot ID from the lower bits of frame_id.
              slot_id = fr_msg.frame_id & 0xffff

              # Assert that the slot ID is 5, as expected.
              self.assertTrue(slot_id == EXPECTED_SLOT_ID,
                              Severity.BLOCKER,
                              "slot_id is wrong")

              # Check if the current frame matches all the expected criteria.
              if (current_cycle in EXPECTED_CYCLE_LIST
                  and fr_msg.channel_name == FR_CHANNEL_1
                  and fr_msg.direction == RX_DIRECTION
                  and fr_msg.payload == FLEXRAY_CORRUPTED_PAYLOAD
                 ):
               
                # Increment the counter for valid packet.
                  nbr_packet_with_expeted_id+=1
                  
                  self.assertTrue(current_cycle in EXPECTED_CYCLE_LIST 
                                  and fr_msg.channel_name==FR_CHANNEL_1 
                                  and fr_msg.direction==1 
                                  and fr_msg.payload ==FLEXRAY_CORRUPTED_PAYLOAD,
                                  Severity.BLOCKER,
                                  "wrong cycle received {0} expected list cycle {1}".format(current_cycle,
                                                                                            EXPECTED_CYCLE_LIST))
        
        self.assertTrue(nbr_packet_with_expeted_id == len(fr_queue),
                        Severity.BLOCKER,
                        "The number of packets is not correct")
   
    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests.
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_flexray_with_interception_function stopping")
