from time import sleep
from .interception_fixture import InterceptionFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *

@metadata(
    tc_id="tca_eth_set_then_unset_intercept_function",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)

class TcaEthSetUnsetInterceptFunction(InterceptionFixture):
    def setUp(self):
        self.logger.info("tca_eth_set_then_unset_intercept_function starting")

    # Create the test case method that holds the main test steps.
    def test_eth_set_then_unset_intercept_function(self):
        
        # Clean up any existing Ethernet listeners for the ethernet channel on Ethernet II protocol.
        self.bus_manager.ethernet_listener(
                bus_name=ETH_RECEIVER_NAME,
                protocol=ETH_PROTOCOL).clean_up()
       
        sleep(0.1)
        
        # Start listening on the Ethernet_channel.
        self.bus_manager.ethernet_listener(bus_name=ETH_RECEIVER_NAME, 
                                           protocol=ETH_PROTOCOL).start_listening()
        
        sleep(0.1)
        
        # Set an interception with a callback function 'change_eth_msg' that will corrupt 
        # the payload before the transmission and inject it in the bus.
        set_function=self.ethernet_channel(ETH_SENDER_NAME).set_interception_function(change_eth_msg)
        
        # Verify that the interception function was set successfully.
        self.assertTrue(set_function,
                        Severity.BLOCKER,
                        "set_function did not work properly.")
       
        # Unset the interception function.
        # After this, frames should pass through the bus unchanged (no modification by interception).
        self.ethernet_channel(ETH_SENDER_NAME).unset_interception_function() 
        
        eth_message=create_eth_msg()
        
        # Transmit the Ethernet message using the Ethernet transmitter.
        transmitter = mtf_ethernet_transmitter() 
        transmit = transmitter.transmit_ethernet_packet(ETH_SENDER_NAME,eth_message)
        
        # Verify that the message was successfully transmitted.
        self.assertTrue(transmit,
                        Severity.BLOCKER,
                        "transmittion  did not work properly.") 

        sleep(1)
       
        # Stop listening on the receiver ethernet channel.
        self.bus_manager.ethernet_listener(
                bus_name=ETH_RECEIVER_NAME,
                protocol=ETH_PROTOCOL).stop_listening()
        
        # Retrieve the received Ethernet messages 
        # from the listener's message queue.
        received_message=self.bus_manager.ethernet_listener(
                bus_name=ETH_RECEIVER_NAME,
                protocol=ETH_PROTOCOL).get_queue()
        
        # Check how many of the received messages have the expected payload.
        count_correct_payload = 0
        
        for ethernet_message in received_message:
                payload=list(ethernet_message['payload'])
                if payload == ETH_PAYLOAD: 
                        count_correct_payload+=1
       
        # Verify that the received message is not corrupted.
        self.assertTrue(count_correct_payload == 1,
                        Severity.BLOCKER,
                        "wrong number of received message")
        
    
    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests.
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_eth_set_then_unset_intercept_function stopping")
