from time import sleep
from .interception_fixture import InterceptionFixture
from xtr import metadata, extra_metadata
from xtr import Severity
from .helper import *
from .config import *

@metadata(
    tc_id="tca_can_set_then_unset_intercept_function",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)

class TcaCanSetUnsetInterceptFunction(InterceptionFixture):
    def setUp(self):
        self.logger.info("tca_can_set_then_unset_intercept_function starting")

    # Create the test case method that holds the main test steps.
    def test_set_then_unset_intercept_can_function(self):
      
      # Start listening for CAN frames on the specified channel.
      self.bus_manager.bus_listener(
            CAN_CHANNEL_NAME, BusType.CAN).start_listening()
      
      # Set an interception with a callback function 'change' that will corrupt the payload
      # before the transmission and inject it in the bus.
      set_function=self.can_channel(CAN_CHANNEL_NAME).set_interception_function(change)
      
      self.assertTrue(set_function,
                      Severity.BLOCKER,
                      "set_function did not work properly.")
      sleep(0.5)
      
      # Unset the interception function. From this point onward,
      # no corrupted frames should be injected into the bus; only the
      # correct frame will be transmitted.
      self.can_channel(CAN_CHANNEL_NAME).unset_interception_function() 
      
      # Send 10 identical CAN frames with ID 0x01 and 8-byte payload.
      for i in range(10):
            self.can_channel(CAN_CHANNEL_NAME).send_frame(CanDataFrame(CAN_FRAME_ID,CAN_PAYLOAD)) 
      sleep(0.5)
      
      # Stop listening for CAN frames.
      self.bus_manager.bus_listener(CAN_CHANNEL_NAME, 
                                    BusType.CAN).stop_listening()
      
      # Retrieve all received frames from the listener's queue.
      can_queue = self.bus_manager.bus_listener(CAN_CHANNEL_NAME, 
                                        BusType.CAN).get_queue() 
      
      # We verify that all the frames have arrived correctly.  
      self.assertTrue(can_queue.qsize() == 10,
                      Severity.BLOCKER,
                      "Some Frames are not received.") 

      # Validate each received frame.
      for can_msg in can_queue.queue:
        self.assertTrue(
            can_msg.channel_name == CAN_CHANNEL_NAME and               # Must be received on the correct channel
            can_msg.direction == RX_DIRECTION and                      # Must be incoming (received) frame
            can_msg.payload == [int(x) for x in CAN_PAYLOAD] and       # Payload should be unchanged (original)
            can_msg.payload_length == 8 and                            # Frame should contain 8 bytes
            can_msg.frame_id == int(CAN_FRAME_ID),                     # Frame ID should match what was sent
            Severity.BLOCKER,
            "Frame is corrupted."  # Error if frame was still affected by the interception function
        )

    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests .
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_can_set_then_unset_intercept_function stopping")
