from .some_ip_fixture import SomeIpFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .config import *
from .helper import *


@metadata(
    tc_id="tca_capture_someip_message",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCaptureSomeipmessage(SomeIpFixture):

    # Create setUp() method.
    def setUp(self):
        self.logger.info("tca_capture_someip_message starting")

    # Create the tearDown() method.
    def tearDown(self):
        # Clean up any remaining test resources.
        self.cleanup_all_controllers()
        self.bus_manager.cleanup_all_listeners()
        
        self.logger.info("tca_capture_someip_message stopping")

    def test_capture_someip_message(self):

        # Set sender channel IP to IP_57.
        change_ip(IP_57, ETH_SENDER_CH)
        # Set receiver channel IP to IP_64.
        change_ip(IP_64, ETH_RECEIVER_CH)

        global raw_payload  # Use global list to store captured SOME/IP raw payloads.

        # Retrieve Ethernet ECUs (ECU4 as sender, ECU2 as receiver) from the communication network.
        ECU4_ETHERNET = self.com_network.try_get_ecu_by_name(ECU_4)
        ECU2_ETHERNET = self.com_network.try_get_ecu_by_name(ECU_2)

        # Activate both ECUs for communication.
        ECU2_ETHERNET.activate()
        ECU4_ETHERNET.activate()

        # Get the SOME/IP service provided by ECU4.
        service = ECU4_ETHERNET.try_get_provided_service_by_name_or_id(SERVICE_ID_1)

        # Get the specific event/message from the service by its method ID.
        event = service.try_get_message_by_id(METHOD_ID_1)

        sleep(1)

        # Get the target simple member (field) from the event using its path.
        member = event.try_get_simple_member_by_path(MEMBER_PATH)

        # Start listening to the raw SOME/IP event messages using the callback function.
        event.start_listening(callback_fnc_m)

        # Set a value to the member, which will be serialized into the message payload.
        member.set_value(MEMBER_SET_VALUE)

        # Serialize the event with the member value and transmit it over the network.
        event.try_serialize_and_transmit()

        sleep(1)

        # Stop listening after the message has been received.
        event.stop_listening()

        # Assert that the captured payload matches the expected value starting from the byte 12. 
        # since the member that we already set its value exists in the message starting from byte 12.
        self.assertEqual(
            raw_payload[-1][12:],  # Get the last captured payload
            EXPECTED_SOME_IP_MESSAGE_PAYLOAD,
            Severity.BLOCKER,
            f"Payload value mismatch expected:{EXPECTED_SOME_IP_MESSAGE_PAYLOAD} but got:{raw_payload[-1][12:]}"
        )

        # Deactivate ECUs to clean up after test.
        ECU2_ETHERNET.deactivate()
        ECU4_ETHERNET.deactivate()