from .io_fixture import IoFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_io_apply_faulty",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaIoApplyFaulty(IoFixture):

    # This method will be executed just before
    # the test case core method execution..
    def setUp(self):
        self.logger.info("tca_io_apply_faulty starting")

    # This method will be executed just after
    # the test case core method execution
    def tearDown(self):
        self.logger.info("tca_io_apply_faulty stopping")

    # Create the test case core method that holds the main test steps.
    def test_apply_faulty_on_io_signal(self):

        # Since IO_CH_1 is a 'VBATSwitch', it has initially a voltage 
        # that is equal to 12(short to Vbat). That's why we started by applying 
        # short to GND on it instead of short to Vbat to avoid false positives scenarios.
        self.io_controller.io_apply_faulty(IO_CH_1,
                                           IoFaultyTypes.ShortCutToGnd)
        
        sleep(0.1)

        voltage = self.io_controller.io_get_last_value(IO_CH_1,
                                                       IoProperty.Voltage)
        
        # Since we Short to ground the channel we expect a voltage of almost 0 
        self.assertEqual(round(voltage) , 
                         GND_VOLTAGE,
                         Severity.BLOCKER, 
                        "The voltage value is wrong") 

        self.io_controller.io_stop_faulty(IO_CH_1,
                                          IoFaultyTypes.ShortCutToGnd)
        
        sleep(0.1)

        self.io_controller.io_apply_faulty(IO_CH_1,
                                           IoFaultyTypes.ShortcutToVbat)
        
        sleep(0.1)

        voltage = self.io_controller.io_get_last_value(IO_CH_1,
                                                       IoProperty.Voltage)
        
        # Since we Short the channel to Vbat we expect a voltage of almost 12 
        self.assertEqual(round(voltage) , 
                         VBAT_VOLTAGE,
                         Severity.BLOCKER, 
                        "The voltage value is wrong")

        self.io_controller.io_stop_faulty(IO_CH_1,
                                          IoFaultyTypes.ShortcutToVbat)
        sleep(0.1)