from .io_fixture import IoFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_get_voltage_value",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaGetIoVoltageValue(IoFixture):

    # This method will be executed just before
    # the test case core method execution.
    def setUp(self):
        self.logger.info("Setup test case")

    # This method will be executed just after
    # the test case core method execution.
    def tearDown(self):
        self.logger.info("Tear down test case")

    # Create the test case core method that holds the main test steps.
    def test_get_io_voltage_value(self):
            
            voltage = self.io_controller.io_get_last_value(IO_CH_1,
                                                        IoProperty.Voltage)
            self.assertEqual(round(voltage),
                            VBAT_VOLTAGE,
                            Severity.BLOCKER,
                            "The value of the voltage we get is wrong")
