from .frame_last_payload_fixture import FrameLastPayloadFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .config import *
from .helper import *


@metadata(
    tc_id="tca_capture_npdu_frame",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCaptureNpduFrame(FrameLastPayloadFixture):
    def setUp(self):
        self.logger.info("tca_capture_npdu_frame starting")

    # Create the test case core method that holds the main test steps.
    def test_capture_Npdu_frame(self):

        npdus_id_set=set()

        # Add an input tunnel to the Npdu manager's configuration.
        self.npdu_manager.add_input_pdu_tunnel(
            channel_name=TUNNEL_CHANNEL_NAME,
            multi_cast_ip_v4_addresses=MULTI_CAST_IP_V4_ADDRESSES,
            multi_cast_port=MULTI_CAST_PORT,
            remote_ip_v4_address=REMOTE_IP_V4_ADDRESS,
            local_port=LOCAL_PORT,
            with_vlan_assign=WITH_VLAN_ASSIGN,
            force_add=FORCE_ADD,
            adapter_name=PHYSICAL_ADAPTER_NAME)
        
        # Start ndpu listener on TUNNEL_CHANNEL_NAME.
        # Listener result will be based on the tunnel 
        # parameters such as the ip addresses and the port.
        self.npdu_manager.start_npdu_listener(TUNNEL_CHANNEL_NAME)

        ecu = self.com_network.try_get_ecu_by_name(ECU_4)
        
        # Start transmission for all output NPdus with the specified IDs and channel name.
        ecu.start_npdus(PDU_ID_SET, channel_name=NPDU_CHANNEL)
        sleep(1)

        # Stop the transmission.
        ecu.stop_npdus(PDU_ID_SET, channel_name=NPDU_CHANNEL)

        # Stop the NPDU listener.
        self.npdu_manager.stop_npdu_listener(TUNNEL_CHANNEL_NAME)

        # Get a list of all the received npdu elements of channel_name.
        npdus=self.npdu_manager.get_all_received_npdu_data(TUNNEL_CHANNEL_NAME,True)

        # Get the actual npdus_id_set.
        for pdu in npdus:
            npdus_id_set.add(pdu.npdu_element.pdu_id)

        self.assertTrue(npdus_id_set== PDU_ID_SET, Severity.BLOCKER,
                        "The captured PDUs are not as expected")

    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_capture_npdu_frame stopping")