from Measurement.listeners.raw_listeners.serial.serial_fixture import SerialFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *

@metadata(
    tc_id="tca_start_serial_listener",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaSerialMessageListener(SerialFixture):

    # Create setUp() method.
    def setUp(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_start_serial_listener starting")

    # Create the tearDown() method.
    def tearDown(self):
        self.logger.info("tca_start_serial_listener stopping")

# Create the test case core method that holds the main test steps.
    def test_serial_message_listener(self):

        # Start the serial listener on SLAVE_CHANNEL.
        self.serial_listener(SLAVE_CHANNEL).start_listening()
        sleep(2)

        # Transmit a serial message from the MASTER_CHANNEL.
        self.serial_transmitter.transmit_message(
            MASTER_CHANNEL, SERIAL_MESSAGE)
        sleep(2)

        # Start the serial listener on SLAVE_CHANNEL.
        self.serial_listener(SLAVE_CHANNEL).stop_listening()

        # Get the queue of messages got in the listener of SLAVE_CHANNEL.
        messages = self.serial_listener(SLAVE_CHANNEL).get_queue()

        # Concatenate the received messages.
        for _ in range(len(SERIAL_MESSAGE)):
            received_message += messages.get().message
        
        # Assert that the received messages are as expected.
        self.assertEqual(received_message,
                         SERIAL_MESSAGE,
                         Severity.BLOCKER,
                         "Serial message mismatch detected, received message is different from expected")
