from .ethernet_fixture import EthernetFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from.config import *


@metadata(
    tc_id="tca_capture_someip_message_with_filter",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCaptureSomeipMessageWithFilter(EthernetFixture):
    def setUp(self):
        self.logger.info("tca_capture_someip_message_with_filter starting")

    # Create the test case core method that holds the main test steps.
    def test_capture_someip_message_with_filter(self):
        # Define a SOME/IP filter to capture only specific messages 
        # according to the specified filter parameters.
        someip_filter = create_someip_filter(
            ip_src=SOMEIP_SRC_IP,
            service_id=SOMEIP_SERVICE_ID,
            method_id=SOMEIP_METHOD_ID,
            msgType=SOMEIP_MSG_TYPE,
        )

        # Create a SOME/IP listener on the specified Ethernet channel for SOME/IP protocol.
        someip_listener = self.bus_manager.ethernet_listener(
            ADAPTER_NAME, SOMEIP_PROTOCOL_TYPE)

        # Apply the filter to the SOME/IP listener.
        someip_listener.configure(someip_filter=someip_filter)

        # Start the SOME/IP listener with silent mode.
        someip_listener.start_listening(silent_mode=True)
        sleep(1)

        msg = self.bus_manager.create_ethernet_message(
            SOMEIP_PROTOCOL_TYPE)


        msg.set_all_bytes(bytearray.fromhex(SOMEIP_MSG_PAYLOAD))

        # transmit the SOME/IP message with udp connection.
        self.someip_transmitter.send_someip_packet_over_udp(
            ADAPTER_NAME, msg)
        sleep(1)

        someip_listener.stop_listening()

        messages = someip_listener.get_queue()

        self.assertNotEqual(len(messages), 0, Severity.BLOCKER,"Queue is empty")
        
        for someip_message in messages:
            
            someip_header = someip_message['someip_message'].someip_header

            self.assertEqual(someip_header.service_identifier, SOMEIP_SERVICE_ID, Severity.BLOCKER,"Wrong service_id for the received SOME/IP message expected")
            self.assertEqual(someip_header.method_identifier, SOMEIP_METHOD_ID, Severity.BLOCKER,"Wrong method_id for the received SOME/IP message")

    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_capture_someip_message_with_filter stopping")