"""Module for group-wide constant values"""
from .helper import EthProtocolType, BusType
SERVICE_IDENTIFIER = 'service_identifier'
METHOD_IDENTIFIER = 'method_identifier'
LENGTH = 'length'
CLIENT_ID = 'client_id'
SESSION_ID = 'session_id'
MESSAGE_TYPE = 'message_type'
RETURN_CODE = 'return_code'
PROTOCOL_VERSION = 'protocol_version'
INTERFACE_VERSION = 'interface_version'
MESSAGE_ID = 'message_id'
REQUEST_ID = 'request_id'

EXPECTED_SERVICE_IDENTIFIER = 0x101
EXPECTED_METHOD_IDENTIFIER = 0x8005
EXPECTED_SOMEIP_LENGTH = 13
EXPECTED_CLIENT_ID = 0
EXPECTED_SESSION_ID = 0
EXPECTED_MESSAGE_TYPE = 'NOTIFICATION'
EXPECTED_RETURN_CODE = 'E_OK'
EXPECTED_PROTOCOL_VERSION = 1
EXPECTED_INTERFACE_VERSION = 1
EXPECTED_MESSAGE_ID = 0x1018005
EXPECTED_REQUEST_ID = 0

# Define the expected SOME/IP header dictionary.
EXPECTED_SOMEIP_HEADER_DICT = {
    SERVICE_IDENTIFIER: str(hex(EXPECTED_SERVICE_IDENTIFIER)),
    METHOD_IDENTIFIER: str(hex(EXPECTED_METHOD_IDENTIFIER)),
    LENGTH: EXPECTED_SOMEIP_LENGTH,
    CLIENT_ID: EXPECTED_CLIENT_ID,
    SESSION_ID: EXPECTED_CLIENT_ID,
    MESSAGE_TYPE: EXPECTED_MESSAGE_TYPE,
    RETURN_CODE: EXPECTED_RETURN_CODE,
    PROTOCOL_VERSION: EXPECTED_PROTOCOL_VERSION,
    INTERFACE_VERSION: EXPECTED_INTERFACE_VERSION,
    MESSAGE_ID: str(hex(EXPECTED_MESSAGE_ID)),
    REQUEST_ID: EXPECTED_REQUEST_ID}

BUS_NAME = "Ethernet_MTF"
SOMEIP_MSG_PAYLOAD = "00e04c1356ed001cd77c2fbf080045000031016e00004011aa0ca030c763a030c77d772a771b001dbd17010180050000000d00000000010102000100000000"
ADAPTER_NAME="Ethernet_MTF"
ETH_PAYLOAD = [0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x50, 0xC2, 0xe4, 0x30, 0x00, 0x88, 0xB5, 0x21, 0x21, 0x54, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x20, 0x61, 0x20, 0x64, 0x65, 0x62, 0x75, 0x67, 0x20, 0x66, 0x72, 0x61, 0x6d, 0x6e, 0x74, 0x20, 0x62, 0x79, 0x20, 0x6d, 0x74, 0x66, 0x20, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x77]
PTP_PROTOCOL_TYPE = EthProtocolType.IS_PTP
ETH_BUS_TYPE = BusType.ETHERNET
PTP_DATA = [0x01, 0x80, 0xc2, 0x00, 0x00, 0x0e, 0x00, 0x80, 0x63, 0x00, 0x09, 0xba, 0x88, 0xf7, 0x02, 0x02, 0x00, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x63, 0xff, 0xff, 0x00, 0x09, 0xba, 0x00, 0x02, 0x04, 0x5e, 0x05, 0x0f, 0x00, 0x00, 0x45, 0xb1, 0x11, 0x49, 0x1c, 0x41, 0x78, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00]
PTP_MESSAGE_KEY = "ptp_message"
MESSAGE_ID_KEY = "message_id"
MESSAGE_TYPE_KEY = "message_type"
EXPECTED_PTP_DICT = {'message_id': '2', 'message_type': 'PDelayReq'}
SOMEIP_SRC_IP = [160,48,199,99]
SOMEIP_SERVICE_ID = 0x101
SOMEIP_METHOD_ID = 0x8005
SOMEIP_MSG_TYPE = 0x02
SOMEIP_PROTOCOL_TYPE = EthProtocolType.IS_SOME_IP