from .can_fixture import CanFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *

@metadata(
    tc_id="tca_capture_can_fd_frames",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCaptureCanFdFrames(CanFixture):
    def setUp(self):
        self.logger.info("tca_capture_can_fd_frames starting")

    # Create the test case method that holds the main test steps.
    def test_capture_can_fd_frames(self):

        can_fd_ch = ChannelFactory().get_can_channel(CAN_FD_CHANNEL_NAME, True)

        # Retrieves the desired can frame object associated with the 
        # frame_id.
        can_fd_fr = can_fd_ch.get_frame(CAN_FD_FRAME_ID)

        # Start listening on the can fd channel.
        can_fd_ch.listener.start_listening()

        # Transmit the frame.
        can_fd_fr.transmitter.transmit_frame(CAN_FD_PAYLOAD)

        sleep(1)

        # Stop listening on the can fd channel.
        can_fd_ch.listener.stop_listening()

        q = can_fd_ch.listener.get_queue()

        # Confirm that the queue is not Null object,
        # meaning there is no error in creating the queue.
        self.assertTrue(q is not None, Severity.BLOCKER,
                        "Error when listening to the can fd bus")

        # Confirm that queue is not empty meaning messages are received.
        self.assertTrue(q.qsize() >= 1, Severity.BLOCKER,
                        "Can fd frame is not received")
        
        event = q.queue[0]

        self.assertTrue(event.frame_id == CAN_FD_FRAME_ID, Severity.BLOCKER,
                        "Can fd frame id mismatch")
        
        self.assertTrue(event.channel_name == CAN_FD_CHANNEL_NAME, Severity.BLOCKER,
                        "Can fd channel_name mismatch")

    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_capture_can_fd_frames stopping")
