"""Module for helper functions and group-wide utilities"""
from time import sleep
from mtf.network_port.channels.channel_factory import ChannelFactory
from mtf.enum_types import Direction, BusType, CanProtocol
from mtf.diag_port.can_tp import CanTp

actual_list = []

def callback(can_frame):
    global actual_list
    message_dict = {
        "channel_name": can_frame.channel_name,
        "frame_id": can_frame.frame_id,
        "payload": can_frame.payload,
        "payload_length": can_frame.payload_length,
        "direction": can_frame.direction}
    actual_list.append(message_dict)
    return actual_list

actual_can_tp_list = []

def can_tp_callback(can_frame):
    global actual_can_tp_list 
    message_dict = {
        "channel_name": can_frame.channel_name,
        "frame_id": hex(can_frame.frame_id),
        "payload": [format(num, 'x') for num in can_frame.payload],
        "payload_length": can_frame.payload_length,
        }
    actual_can_tp_list.append(message_dict)
    return actual_can_tp_list