import os
import sys
import time
import matplotlib
# Set Agg as the backend for non-GUI environments
# (instead of tkinter) to avoid thread issues.
matplotlib.use('Agg')
import matplotlib.pyplot as plt
current_dir = os.path.dirname(os.path.abspath(__file__))
sys.path.append(os.path.join(current_dir, "Python_Enums"))
from .config import *
from mtf.libs.mtf_pybinder.ASAM.XIL.Implementation.TestbenchFactory.Testbench import TestbenchFactory
from ASAM.XIL.Interfaces.Testbench.Common.Signal.Enum.interpolationtypes import InterpolationTypes
from ASAM.XIL.Interfaces.Testbench.Common.Script.Enum.scriptstate import ScriptState
from ASAM.XIL.Interfaces.Testbench.Common.VariableRef.Enum.valuerepresentation import ValueRepresentation
from collections import Counter

def plot_signal(x_vector, y_vector,
                graph_title, lab=None,
                filename=PLOT_PATH):
    """Plots a signal and saves it to a file.

    Args:
        x_vector (list or array): The list or array of X values.
        y_vector (list or array): The list or array of Y values.
        graph_title (str): The title of the plot.
        lab (str): The label for the line in the plot.
            Defaults to None.
        filename (str): The path to save the plot image.
            Defaults to PLOT_PATH.
    """
    # Ensures a fresh figure
    plt.figure()
    plt.plot(x_vector, y_vector, label=lab)
    plt.xlabel(X_VECTOR_NAME)
    plt.ylabel(Y_VECTOR_NAME)
    plt.title(graph_title)
    plt.legend()
    plt.grid()
    plt.savefig(filename, bbox_inches='tight')
    # Closes the figure to free memory
    plt.close()