# Test Case: Modify a CAN signal values from a DB file using XIL Sinal generator module 

## Overview
 
This test verifies the modification of a CAN signal
-loaded from a DB file- using user defined values.
It performs the following steps:
 
1- Load a CAN frame from a DB file and start its transmission.

2- Generate a list of user-specified values via interpolations based on the chosen signal type.

3- Apply those values to the selected signal from the frame.

4- Activate an observer to confirm that the live CAN signal values match the generated values.

## Preconditions

This test case cannot be executed unless the following preconditions are met:

- **Virtual environment:** It is recommended to use a virtual environment to avoid potential conflicts, especially when working with 
  **XTR**.

- **Required Python module:** install `matplotlib` (used for visualization or plotting).
 
    ```bash
    pip install matplotlib
    ```

- **ASAM Python_Enums folder:** 
  - Obtain the ASAM-standard folder named Python_Enums, which contains the required enum classes.
  - Place this Python_Enums folder inside the test series directory
  - The helper script (lines 5–6) will automatically add this folder to the import path allowing 
    you to import its classes (lines 8–11) in the test case.

## Notes

Users must ensure they provide values appropriate to the signal type—physical or raw—since each type has its own specific valid range.