# Test Cases: Establish an XCP communication with an Ecu using XIL Ecu Port 

## Overview
 
This test series includes several test cases to verify proper XCP communication with the ECU (test cases for successful connection setup, upload and download of measurement variables, as well as DAQ configuration and real-time data acquisition)
It performs the following steps:
 
1- Define an ECUPORT instance, configure it with the A2L file and extract device and variables.

2- Start the communication between the Ecu and the master.

3- Write a value for a selected variable in the ecu memory with a specific representation.

4- Get variable value from the Ecu memory using a simple read function for upload and using capture or signal monitor module for data acquisition.

5- Stop the communication between the Ecu and the master.

## Preconditions

This test case cannot be executed unless the following preconditions are met:

- **Virtual environment:** It is recommended to use a virtual environment to avoid potential conflicts, especially when working with 
  **XTR**.

- **ASAM Python_Enums folder:** 
  - Download the ASAM-standard folder named Python_Enums, which contains the required enum classes 
    from this link: https://www.asam.net/standards/detail/xil/
  - Place this Python_Enums folder under test case's group(in our case under XIL_Ecu_port_testseries folder). The helper script (lines 7–8) will automatically add this folder to the import path allowing you to import its classes(lines 11–17) in the test case.

## Notes

Users will also find in this test series a simulated ECU and the corresponding A2L file located in the config folder. The test cases can be executed directly using these provided components. Using a different simulator or A2L file will cause the tests to fail.