from .xcp_fixture import XcpFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .config import *
from .helper import *


@metadata(
    tc_id="tca_write_read_xcp",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaWriteReadXcp(XcpFixture):
    def setUp(self):
        
        self.logger.info("Setup test case")

    def tearDown(self):

        self.logger.info("Tear down test case")


    def test_write_read_xcp_variable(self):
        """
        Test the write and read functionality of XCP communication.

        This test initializes the XCP controller, connects to the ECU,
        writes a value to an A2L variable, reads it back, and verifies
        that the written value matches the read value.
        """

        xcp_controller_instance  = self.xcp_controller

        self.addStep(
                f"Step 1.", 
                f" Initialize and connect the XCP controller")

        xcp_controller_instance.init(ECU_NAME, CHANNEL_NAME, A2L_FILE_PATH)

        connect_xcp=xcp_controller_instance.connect(
            ecu_name=ECU_NAME,
            channel_name=CHANNEL_NAME,
            protocol=TransportProtocol.TCP,
            dst_host=DST_HOST,
            dst_port=DST_PORT
        )

        self.assertTrue(connect_xcp,
                        Severity.BLOCKER,
                        f"An error occurs while trying to connect the ecu with XCP controller")

        self.addStep(
                f"Step 2.", 
                f" Write the specified value to the A2L variable")

        write_xcp_variable = xcp_controller_instance.write(
            ecu_name=ECU_NAME,
            channel_name=CHANNEL_NAME,
            a2l_object=A2L_VARIABLE_TO_WRITE,
            value=VALUE_TO_WRITE
        )

        time.sleep(0.5)

        self.assertTrue(write_xcp_variable,
                        Severity.BLOCKER,
                        f"An error occurs while writing to the A2L variable")


        self.addStep(
                f"Step 3.", 
                f" Read the value back from the A2L variable")

        return_value = xcp_controller_instance.read(ECU_NAME, CHANNEL_NAME, A2L_VARIABLE_TO_READ)

        # Ensure the written value matches the value read back.
        self.assertEqual(VALUE_TO_WRITE,
                         return_value[1], # 'return_value' is a tuple: (read_status, read_value)
                         Severity.BLOCKER,
                         "The A2L variable value written is different from the returned value.")

        # Wait to ensure clean disconnection process.
        time.sleep(0.5)

        self.addStep(
                f"Step 4.", 
                f" Disconnect the XCP controller")

        xcp_controller_instance.disconnect(ECU_NAME, CHANNEL_NAME)
