from .flexray_fixture import FlexrayFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_flexray_tp_transmitter",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaFlexrayTpTransmitter(FlexrayFixture):
    def setUp(self):
        self.logger.info("tca_flexray_tp_transmitter starting")

    # Create the test case method that holds the main test steps.
    def test_flexray_tp_transmitter(self):
       
        # Create an instance of the FlexrayTp class.
        flexray_sender = FlexrayTp()
        
        # Create an instance of the FlexrayTpConfig class with the 
        # required parameters.
        config_sender = FlexrayTpConfig(FR_CHANNEL_NAME, # Channel name used for transmission.
                                        RX_FRAME_ID, # Frame id of FRTP instance that will receive the traffic.
                                        TARGET_ADDRESS, # Address used for payloads received by the FRTP sender.
                                        TX_FRAME_ID, # Frame id of FRTP sender.
                                        SOURCE_ADDRESS, # Address used for payloads transmitted by the FRTP sender.
                                        PDU_LENGTH, # Maximum number of bytes in the flexray payload.
                                        FLOW_TIMEOUT, # Maximum allowed time between two consecutive frames.
                                        COMMUNICATION_CHANNEL) # Flexray channel type(A or B).
        
        # Configure the FlexRay TP instance by binding it 
        # to the configuration class using the 
        # bind() method.
        bind_sender = flexray_sender.bind(config_sender)
        
        self.assertTrue(bind_sender, 
                        Severity.BLOCKER,
                        "FlexRay tp sender is not correctly configured.")

        # Transmit the FlexRay frame with payload length more 
        # than the pdu length.
        flex_transmit = flexray_sender.send(EXTENDED_FR_PAYLOAD)

        sleep(2)

        # Confirm the correct transmission by verifying the boolean return value of send().
        # If there are no issues during transmission, the return value should
        # be true.
        self.assertTrue(flex_transmit, Severity.BLOCKER,
                        "Error when sending a FlexRay tp message.")

    def tearDown(self):
        # Clean up any remaining test resources.
        self.cleanup_all_controllers()
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_flexray_tp_transmitter stopping")
