from .flexray_fixture import FlexrayFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_flexray_tp_controller_transmit",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaFlexrayTpControllerTransmit(FlexrayFixture):
    def setUp(self):
        self.logger.info("tca_flexray_tp_transmitter starting")

    # Create the test case method that holds the main test steps.
    def test_flexray_tp_controller_transmit(self):
       
        # Create a FlexRay TP configuration based on the addressing type,
        # PDU length, Flow timeout and FlexRayTP standard type 
        # (AR TP ISO in our case).
        flexraytp_config = flexray_tp_config(ADDRESSING_TYPE,
                                             FLOW_TIMEOUT,
                                             PDU_LENGTH_AR_TP,
                                             AR_TP_ISO_TYPE)
        
        # Use the defined configuration, along with the addresses and frame IDs, 
        # to create an instance of FlexRay TP using the MTF FlexRay TP controller.
        mtf_controller_sender = mtf_flexray_tp_controller(FR_CHANNEL_NAME,
                                                          CONTROLLER_TX_FRAME_ID,
                                                          SOURCE_ADDRESS,
                                                          CONTROLLER_RX_FRAME_ID,
                                                          TARGET_ADDRESS,
                                                          flexraytp_config)
        
        # Create a callback function and configure the FlexRay TP sender with it. 
        # The callback will be used for the transmission of the communication traffic.
        flexray_callback = flexrayCallback()
        
        configure_sender = mtf_controller_sender.configure(flexray_callback.msg_callback)
        
        self.assertTrue(configure_sender, 
                        Severity.BLOCKER,
                        "MTF controller sender is not correctly configured.")
        
        # Transmit the flexray tp frame with payload length more
        # than the pdu length.
        flex_transmit = mtf_controller_sender.transmit(FR_AR_TP_PAYLOAD)
        sleep(2)
        
        # Confirm the correct transmission by verifying the boolean return value of transmit().
        # If there are no issues during transmission, the return value should
        # be true.
        self.assertTrue(flex_transmit, Severity.BLOCKER,
                        "Error when sending a flexray message.")

    def tearDown(self):
        # Clean up any remaining test resources.
        self.cleanup_all_controllers()
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_flexray_tp_transmit stopping")
