"""Module for group-wide constant values"""
from .helper import MtfFrTpType,FRCommunicationChannel,MtfFrTpAddressLength,FrFrameIdParts
FR_CHANNEL_NAME = 'B2_FlexRay'
FR_FRAME_ID = '5.2.64'  # Its type is str.
FR_PAYLOAD = [0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8,
              0x9, 0xa, 0xb, 0xc, 0xd, 0xf, 0x10]

RX_FRAME_ID = "173.0.1"
CONTROLLER_RX_FRAME_ID = FrFrameIdParts(slot_id=173,offset=0,repetition=1)
TARGET_ADDRESS = 0x11
TX_FRAME_ID = "210.0.1"
CONTROLLER_TX_FRAME_ID = FrFrameIdParts(slot_id=210,offset=0,repetition=1)
SOURCE_ADDRESS = 0xf8
ADDRESSING_TYPE = MtfFrTpAddressLength.TWO_BYTES
PDU_LENGTH = 22
PDU_LENGTH_AR_TP = 10
FLOW_TIMEOUT = 2000
EXTENDED_FR_PAYLOAD = list(range(0, 25))
FR_AR_TP_PAYLOAD = list(range(0, 14)) # For the AR TP ISO standard , the length of the data list should be represented in 4 bits(maximum 15).
AR_TP_ISO_TYPE = MtfFrTpType.AR_TP_ISO
COMMUNICATION_CHANNEL = FRCommunicationChannel.A