from .ethernet_fixture import EthernetFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *

@metadata(
    tc_id="tca_eth_transmitter",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaEthTransmitter(EthernetFixture):
    def setUp(self):
        self.logger.info("tca_eth_transmitter starting")

    # Create the test case method that holds the main test steps.
    def test_eth_transmitter(self):

        eth_ch = ChannelFactory().get_ethernet_channel(ETH_CHANNEL)

        # Transmit an ethernet payload.
        eth_transmit = eth_ch.transmitter.transmit_frame(ETH_PAYLOAD)

        sleep(2)

        # Confirm the correct transmission by verifying the boolean return value of transmit_frame().
        # If there are no issues during transmission, the return value should
        # be true.
        self.assertTrue(eth_transmit, Severity.BLOCKER,
                        "Error when sending Ethernet payload")

    def tearDown(self):
        # Clean up any remaining test resources.
        self.cleanup_all_controllers()
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_eth_transmitter stopping")