from .can_fixture import CanFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_can_transmitter",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCanTransmitter(CanFixture):
    def setUp(self):
        self.logger.info("tca_can_transmitter starting")

    # Create the test case method that holds the main test steps.
    def test_can_transmitter(self):

        can_ch = ChannelFactory().get_can_channel(CAN_CHANNEL_NAME, False)

        # Retrieves the desired can frame object associated with the 
        # frame_id.
        can_fr = can_ch.get_frame(CAN_FRAME_ID)

        # Transmit the can frame.
        can_transmit = can_fr.transmitter.transmit_frame(CAN_PAYLOAD)

        sleep(2)

        # Confirm the correct transmission by verifying the boolean return value of transmit_frame().
        # If there are no issues during transmission, the return value should
        # be true.
        self.assertTrue(can_transmit, Severity.BLOCKER,
                        "Error when sending a can fd message")

    def tearDown(self):
        # Clean up any remaining test resources.
        self.cleanup_all_controllers()
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_can_transmitter stopping")