from .can_fixture import CanFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_can_tp_transmitter",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCanTpTransmitter(CanFixture):
    def setUp(self):
        self.logger.info("tca_can_tp_transmitter starting")

    # Create the test case method that holds the main test steps.
    def test_can_tp_sender(self):
        
        # Create two instances of the CanTP class and configure them with the 
        # required parameters. Certain parameters values must be inverted 
        # between the sender and receiver (e.g.,RX and TX frame IDs,or source 
        # and target addresses) to properly establish communication.
        can_sender= CanTp()
        
        can_sender.Configure(CAN_CM_CHANNEL, # Channel name used for transmission.
                             RX_FRAME_ID, # Frame id of canTP instance that will receive the traffic.
                             TX_FRAME_ID, # Frame id of canTP sender.
                             CAN_PROTOCOL_TYPE, # Protocol type of the CanTP communication (CAN or CAN FD).
                             PDU_LENGTH, # Maximum number of bytes in the can payload.
                             PADDING_VALUE, # Value used to fill the remaining bytes of a CAN payload to match the pdu length.
                             FLOW_TIMEOUT, # Maximum allowed time between two consecutive frames.
                             source_address=SOURCE_ADDRESS, # Address used for payloads received by the CanTP sender.
                             target_address =TARGET_ADDRESS)  # Address used for payloads transmitted by the CanTP sender.
        
        # Transmit the can tp frame with payload length less than 8 bytes.
        single_frame_transmit = can_sender.send(CAN_PAYLOAD)

        sleep(2)

        # Confirm the correct transmission by verifying the boolean return value of send method.
        # If there are no issues during transmission, the return value should
        # be true.
        self.assertTrue(single_frame_transmit, 
                        Severity.BLOCKER,
                        "Error when sending one can message")
        
        # Transmit the can tp frame with payload length more than 8 bytes
        # (14 bytes in our example) which will be sent in multiple segments.
        consecutive_frame_transmit = can_sender.send(EXTENDED_CAN_PAYLOAD)
        
        self.assertTrue(consecutive_frame_transmit,
                        Severity.BLOCKER,
                        "Error when sending multiple can messages")
        
        can_sender.close()

    def tearDown(self):
        # Clean up any remaining test resources.
        self.cleanup_all_controllers()
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_can_tp_transmitter stopping")