from .load_burst_injection_fixture import LoadBurstInjectionFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_ethernet_burst_transmission",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaEthernetBurstTransmission(LoadBurstInjectionFixture):
    def setUp(self):
        self.logger.info("tca_ethernet_burst_transmission starting")

    # Create the test case core method that holds the main test steps.
    def test_ethernet_burst_transmission(self):

        frame_list_eth = []

        mtf_burst = create_mtf_burst()

        # Prepare Ethernet burst frames.
        for i in range(0, 255):
            frame_list_eth.append(burst_ethernet_frame(
                i + 1, ETHERNET_PAYLOAD))

        mtf_burst.configure_frame_list(ETHERNET_BURST_DURATION,  # duration_ms : the duration of the burst
                                       ETHERNET_BURST_FREQUENCY,  # frequency : burst frequency (frames per second)
                                       [ETHERNET_CHANNEL_NAME],   # channel_list : a list of channel names to send the burst on
                                       False,  # stop_on_error : whether a transmission error should abort the burst
                                       frame_list_eth)  # frames : a list of frames to send

        # Start listening on the Ethernet channel.
        self.bus_manager.ethernet_listener(
            bus_name=ETHERNET_CHANNEL_NAME,
            protocol=EthProtocolType.EthernetII).start_listening()

        # Start transmitting the burst.
        mtf_burst.transmit()

        sleep(2)

        # Stop listening on the Ethernet channel.
        self.bus_manager.ethernet_listener(
            bus_name=ETHERNET_CHANNEL_NAME,
            protocol=EthProtocolType.EthernetII).stop_listening()

        # Get the listener queue that contains Ethernet frames.
        message_queue = self.bus_manager.ethernet_listener(
            bus_name=ETHERNET_CHANNEL_NAME,
            protocol=EthProtocolType.EthernetII).get_queue()

        filtred_ethernet_messages = filter_ethernet_msgs(message_queue, MAC_ADDRESS_FILTER)

        # Clears burst configuration.
        mtf_burst.clear()

        # Check that the listener queue size divided by 2 is equal to NUMBER_OF_ETHERNET_FRAMES.
        # Each frame will be duplicated(Rx and Tx frames) since we are using a virtual adapter.
        self.assertEqual(len(filtred_ethernet_messages)/2,
                         NUMBER_OF_ETHERNET_FRAMES, 
                         Severity.BLOCKER,
                         "Number of captured frame is not as expected")

    def tearDown(self):
        self.logger.info("tca_ethernet_burst_transmission stopping")