from .com_stack_fixture import ComStackFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_trigger_event_with_created_nodes",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaTriggerEventWithCreatedNodes(ComStackFixture):

    # Create setUp() method.
    def setUp(self):
        self.logger.info("tca_trigger_event_with_created_nodes starting")

    # Create the tearDown() method.
    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests
        self.bus_manager.cleanup_all_listeners()
    
        self.logger.info("tca_trigger_event_with_created_nodes stopping")

    def test_trigger_event_with_created_nodes(self):

        # Set the IP address of the provider Ethernet channel to IP_57.
        change_ip(IP_57, ETH_SENDER_CH)
        # Set the IP address of the consumer Ethernet channel to IP_64.
        change_ip(IP_64, ETH_RECEIVER_CH)

        # Define a SOME/IP filter to capture only specific messages 
        # according to the specified filter parameters.
        someip_filter = create_someip_filter(ip_src=IP_57_list,
                                             service_id=SERVICE_ID_1,
                                             method_id=METHOD_ID_1,
                                             msgType=SOMEIP_02_MSG_TYPE,
                                             returnCode=None
                                            )
        
        # Get the Ecu 2 and Ecu 4 instances for the configured Ecus classes.
        ECU2,ECU4 = create_someip_nodes()

        self.assertNotEqual(ECU2,
                            None,
                            Severity.BLOCKER,
                            "Unable to get the ECU by name.")
        
        self.assertNotEqual(ECU4,
                            None,
                            Severity.BLOCKER,
                            "Unable to get the ECU by name.")
        
        # Activate the two Ecu instances.
        ECU2.activate()
        sleep(0.5)
        
        ECU4.activate()
        sleep(0.5)
        
        # ECU4 will try to retrieve the provided service SERVICE_ID_1.
        service = ECU4.try_get_provided_service_by_name_or_id(
            SERVICE_ID_1)
        
        self.assertNotEqual(service,
                            None,
                            Severity.BLOCKER,
                            "Unable to get the service by id.")
        
        # From the provided service, retrieve the event by its method ID.
        event = service.try_get_message_by_id(METHOD_ID_1)

        self.assertNotEqual(event,
                            None,
                            Severity.BLOCKER,
                            "Unable to get the event by id.")
        
        # Create a SOME/IP listener on the specified 
        # Ethernet channel for SOME/IP protocol.
        someip_listener = self.bus_manager.ethernet_listener(ETHERNET_CHANNEL, 
                                                             SOMEIP_PROTOCOL_TYPE)
        
        # Apply the filter to the SOME/IP listener.
        someip_listener.configure(someip_filter=someip_filter)

        # Start the SOME/IP listener with silent mode.
        someip_listener.start_listening(silent_mode=True)
        sleep(1)
        
        # Retrieve the simple member from the message 
        # using its defined path.
        member = event.try_get_simple_member_by_path(MEMBER_PATH)

        # Set the member’s value to 1.
        member.set_value(1)
        
        # Serialize and transmit the event over the network.
        event.try_serialize_and_transmit()
        sleep(2)

        someip_listener.stop_listening()
        
        # Retrieve all captured messages from the listener's queue.
        messages = someip_listener.get_queue()

        someip_listener.clean_up()
        
        # Verify that the queue is not empty, 
        # so at least one message was captured.
        self.assertTrue(len(messages)!=0,
                        Severity.BLOCKER,
                        "Messages length is 0.")
        
        # Extract the payload from each message received.
        for message in messages:
            Actual_payload = tuple(message[SOMEIP_MSG].payload)

        # Check that the payload contains the configured member with its corresponding value,
        # while the remaining members retain their default values.
        self.assertEqual(Actual_payload,
                         EXPECTED_SOMEIP_CREATED_EVENT_PAYLOAD,
                         Severity.BLOCKER,
                         "Expected some/ip event payload is different from the expected payload.")
                        
        # Deactivate both ECUs to clean up after test execution.
        ECU2.deactivate()
        ECU4.deactivate()