from .com_stack_fixture import ComStackFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_trigger_event",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaTriggerSomeipEvent(ComStackFixture):

    # Create setUp() method.
    def setUp(self):
        self.logger.info("tca_trigger_event starting")

    # Create the tearDown() method.
    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests
        self.bus_manager.cleanup_all_listeners()
    
        self.logger.info("tca_trigger_event stopping")

    def test_trigger_event(self):

        # Set the IP address of the provider Ethernet channel to IP_55.
        change_ip(IP_57, ETH_SENDER_CH)
        # Set the IP address of the consumer Ethernet channel to IP_64.
        change_ip(IP_64, ETH_RECEIVER_CH)

        # Define a SOME/IP filter to capture only specific messages 
        # according to the specified filter parameters.
        someip_filter = create_someip_filter(ip_src=IP_57_list,
                                             service_id=SERVICE_ID_1,
                                             method_id=METHOD_ID_1,
                                             msgType=SOMEIP_02_MSG_TYPE,
                                             returnCode=None
                                            )
        
        # Get ECU4 (provider) and the ECU2(consumer) 
        # instance from the communication network and activate it.
        ECU4_ETHERNET = self.com_network.try_get_ecu_by_name(ECU_4)
        ECU2_ETHERNET = self.com_network.try_get_ecu_by_name(ECU_2)

        self.assertNotEqual(ECU2_ETHERNET,
                            None,
                            Severity.BLOCKER,
                            "Unable to get the ECU by name.")
        
        self.assertNotEqual(ECU4_ETHERNET,
                            None,
                            Severity.BLOCKER,
                            "Unable to get the ECU by name.")

        ECU2_ETHERNET.activate()
        ECU4_ETHERNET.activate()
        
        # ECU4 will try to retrieve the provided service SERVICE_ID_1.
        service = ECU4_ETHERNET.try_get_provided_service_by_name_or_id(SERVICE_ID_1)
        
        self.assertNotEqual(service,
                            None,
                            Severity.BLOCKER,
                            "Unable to get the service by id.")
        
        # From the provided service, retrieve the event by its method ID.
        event = service.try_get_message_by_id(METHOD_ID_1)

        self.assertNotEqual(event,
                            None,
                            Severity.BLOCKER,
                            "Unable to get the event by id.")

        sleep(1)
        someip_listener = self.bus_manager.ethernet_listener(ETHERNET_CHANNEL, 
                                                             SOMEIP_PROTOCOL_TYPE)
        
        # Apply the filter to the SOME/IP listener.
        someip_listener.configure(someip_filter=someip_filter)

        # Start the SOME/IP listener with silent mode.
        someip_listener.start_listening(silent_mode=True)
        sleep(1)
        
        # Retrieve the simple member from the message 
        # using its defined path.
        member = event.try_get_simple_member_by_path(MEMBER_PATH)
        member.set_value(1)
        
        # Serialize and transmit the event over the network.
        event.try_serialize_and_transmit()
        sleep(1)

        someip_listener.stop_listening()
        
        # Retrieve all captured messages from the listener's queue.
        messages = someip_listener.get_queue()

        someip_listener.clean_up()
        
         # Verify that the queue is not empty, 
        # so at least one message was captured.
        self.assertTrue(len(messages)!=0,
                        Severity.BLOCKER,
                        "Messages length is 0.")

        for message in messages:
            Actual_payload = tuple(message[SOMEIP_MSG].payload)

        self.assertEqual(Actual_payload[12:],
                         EXPECTED_SOMEIP_EVENT_PAYLOAD[12:],
                         Severity.BLOCKER,
                         "Expected some/ip event payload is different from the expected payload.")
                        
        # Deactivate both ECUs to clean up after test execution.
        ECU2_ETHERNET.deactivate()
        ECU4_ETHERNET.deactivate()