from .com_stack_fixture import ComStackFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .config import *
from .helper import *


@metadata(
    tc_id="tca_set_someip_method_response",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TestSetSomeipMethodResponse(ComStackFixture):

    # Create setUp() method.
    def setUp(self):
        self.logger.info("tca_set_someip_method_response starting")

    # Create the tearDown() method.
    def tearDown(self):

        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests
        self.bus_manager.cleanup_all_listeners()

        self.logger.info("tca_set_someip_method_response stopping")
        
    def test_set_someip_method_response(self):

        # Set the IP address for the provider Ethernet channel to IP_55.
        change_ip(IP_55, ETH_SENDER_CH)

        # Set the IP address for the consumer Ethernet channel to IP_64.
        change_ip(IP_64, ETH_RECEIVER_CH)

        # Retrieve ECU5 (provider) from the communication network and activate it.
        ECU5_ETHERNET = self.com_network.try_get_ecu_by_name(ECU_5)
        ECU5_ETHERNET.activate()
        sleep(0.5)

        # Retrieve ECU2 (consumer) from the communication network and activate it.
        ECU2_ETHERNET = self.com_network.try_get_ecu_by_name(ECU_2)
        ECU2_ETHERNET.activate()
        sleep(0.5)

        # ECU2 will try to retrieve the consumed service SERVICE_ID_2.
        service_2 = ECU2_ETHERNET.try_get_consumed_service_by_name_or_id(SERVICE_ID_2)
        sleep(0.5)

        # From the consumed service, retrieve the message by its method ID.
        method_2 = service_2.try_get_message_by_id(METHOD_ID_2)
        sleep(0.5)

        # Create a SOME/IP listener on the specified Ethernet channel for SOME/IP protocol.
        someip_listener = self.bus_manager.ethernet_listener(
            ETHERNET_CHANNEL, SOMEIP_PROTOCOL_TYPE)

        # Define a SOME/IP filter to capture only specific messages 
        # according to the specified filter parameters.
        someip_filter = create_someip_filter(ip_src=IP_55_list,
                                             service_id=SERVICE_ID_2,
                                             method_id=METHOD_ID_2,
                                             msgType=MSG_TYPE_OK,
                                             returnCode=RETURN_CODE
                                            )

        # Apply the filter to the SOME/IP listener.
        someip_listener.configure(someip_filter=someip_filter)

        # Start the SOME/IP listener in silent mode.
        someip_listener.start_listening(silent_mode=True)
        sleep(1)

        # Confirm that the message object was retrieved successfully.
        self.assertNotEqual(method_2,
                            None,
                            Severity.BLOCKER,
                            "Unable to get the message by id.")

        # Retrieve the simple member from the message using its defined path.
        member = method_2.try_get_simple_member_by_path(SIMPLE_MEMBER_PATH_1)
        sleep(0.5)

        # Set the member value to 1, which will be included in the outgoing SOME/IP payload.
        member.set_value(1)
        sleep(1)

        # Serialize and transmit the message over the network.
        method_2.try_serialize_and_transmit()
        sleep(1)

        # Stop the SOME/IP listener after capturing the response.
        someip_listener.stop_listening()

        # Retrieve all captured messages from the listener's message queue.
        messages = someip_listener.get_queue()

        # Assert that exactly one message was received.
        self.assertTrue(
            len(messages) == 1,
            Severity.BLOCKER,
            f"Queue is Empty and no response is got."
        )
        
        # Assert that the message received correspond to the expected OK response.
        for message in messages:
            self.assertTrue(
                str(message[SOMEIP_MSG].someip_header.get_message_type())=="RESPONSE",
                Severity.BLOCKER,
                f"message_type value mismatch expected: 'RESPONSE' but got: {str(message[SOMEIP_MSG].someip_header.get_message_type())}"
            )


        # Deactivate both ECUs to clean up resources.
        ECU2_ETHERNET.deactivate()
        ECU5_ETHERNET.deactivate()