from .com_stack_fixture import ComStackFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .config import *
from .helper import *


@metadata(
    tc_id="tca_set_someip_method_request",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaSetSomeipMethodRequest(ComStackFixture):

    # Create setUp() method.
    def setUp(self):
        self.logger.info("tca_set_someip_method_request starting")

    # Create the tearDown() method.
    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests.
        self.bus_manager.cleanup_all_listeners()
        
        self.logger.info("tca_set_someip_method_request stopping")
        
    def test_set_someip_method_request(self):

        # Set the IP address of the provider Ethernet channel to IP_55.
        change_ip(IP_55, ETH_SENDER_CH)
        # Set the IP address of the consumer Ethernet channel to IP_64.
        change_ip(IP_64, ETH_RECEIVER_CH)

        # Initialize an empty list to store the actual received payloads.
        actual_payload = []

        # Get ECU5 (provider) instance from the communication network and activate it.
        ECU5_ETHERNET = self.com_network.try_get_ecu_by_name(ECU_5)
        ECU5_ETHERNET.activate()
        sleep(0.5)

        # Get ECU2 (consumer) instance from the communication network and activate it.
        ECU2_ETHERNET = self.com_network.try_get_ecu_by_name(ECU_2)
        ECU2_ETHERNET.activate()
        sleep(0.5)

        # ECU2 will try to retrieve the consumed service SERVICE_ID_2.
        service_1 = ECU2_ETHERNET.try_get_consumed_service_by_name_or_id(SERVICE_ID_2)
        sleep(0.5)

        # From the service, get the message (method) using METHOD_ID_2.
        method_1 = service_1.try_get_message_by_id(METHOD_ID_2)
        sleep(0.5)

        # Set up a SOME/IP listener on the specified Ethernet channel and protocol.
        someip_listener = self.bus_manager.ethernet_listener(ETHERNET_CHANNEL, 
                                                             SOMEIP_PROTOCOL_TYPE)

        # Define a SOME/IP filter to capture only specific messages 
        # according to the specified filter parameters.
        someip_filter = create_someip_filter(ip_src=IP_64_list,
                                             service_id=SERVICE_ID_2,
                                             method_id=METHOD_ID_2,
                                             msgType=MSG_TYPE_REQ,
                                             returnCode=RETURN_CODE
                                            )

        # Apply the filter to the SOME/IP listener.
        someip_listener.configure(someip_filter=someip_filter)

        # Start listening for messages, with silent_mode enabled.
        # to get the result in the queue.
        someip_listener.start_listening(silent_mode=True)
        sleep(1)

        # Get the simple member from the message by its path.
        member = method_1.try_get_simple_member_by_path(SIMPLE_MEMBER_PATH_1)
        sleep(0.5)

        # Set the member’s value to 1.
        member.set_value(1)
        sleep(1)  

        # Serialize the message and send it over the network.
        method_1.try_serialize_and_transmit()
        sleep(1)  

        # Stop listening after message is sent.
        someip_listener.stop_listening()

        # Retrieve all captured SOME/IP messages from the listener's queue.
        messages = someip_listener.get_queue()

        # Verify that at least one message was captured.
        self.assertTrue(len(messages) != 0,
                        Severity.BLOCKER,
                        f"Queue is Empty"
                       )

        # Extract payloads from all received messages and convert each one to tuple format.
        for message in messages:
            actual_payload.append(tuple(message[SOMEIP_MSG].payload))

        # Compare the actual captured payload with the expected payload.
        self.assertEqual(actual_payload,
                         ACTUAL_REQ_PAYLOAD,
                         Severity.BLOCKER,
                         f"Payload value mismatch expected: {ACTUAL_REQ_PAYLOAD} but got: {actual_payload}"
                        )

        # Deactivate both ECUs to clean up after test execution.
        ECU2_ETHERNET.deactivate()
        ECU5_ETHERNET.deactivate()