from .com_stack_fixture import TransmissionFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *

@metadata(
    tc_id="tca_set_pdu_value",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaSetPduValue(TransmissionFixture):

    # This method will be executed just before
    # the test case core method execution.
    def setUp(self):
        self.logger.info("tca_set_pdu_value starting")

    # This method will be executed just after
    # the test case core method execution.
    def tearDown(self):
        self.logger.info("tca_set_pdu_value stopping")

    # Create the test case core method that holds the main test steps.
    def test_set_pdu_value_little_endian(self):
        
        # Choose a frame id from the database and start the transmission. 
        # This frame contains two signals with the value of the CRC and counter,
        # The rest of signals have the default value 0xff.
        self.legacy_frame(CHANNEL_NAME,FRAME_ID).start_transmission()
        
        sleep(0.5)
        
        # Select a PDU name that corresponds to the specified frame ID, and modify a chosen
        # number of bytes in this PDU using user-defined values. The number of bytes to
        # modify is determined by the start bit and the bit number.
        result_set = self.legacy_pdu(CHANNEL_NAME,FRAME_ID,PDU_NAME).set_pdu_bits_value(SIGNAL_VALUE_LIST,
                                                                                        START_BIT,
                                                                                        BIT_NUMBER,
                                                                                        BIT_ORDER_LE,
                                                                                        True)
        
        # Assert that the boolean result is True after setting the PDU bit values.
        self.assertTrue(result_set,
                        Severity.BLOCKER,
                        "pdu values are not set correctly.")
        
        # Stop the transmission.
        self.legacy_frame(CHANNEL_NAME,FRAME_ID).stop_transmission()