from .com_stack_fixture import ComStackFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *

@metadata(
    tc_id="tca_activate_sending_specific_frame",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaActivateSendingSpecificFrame(ComStackFixture):
    def setUp(self):
        self.logger.info("tca_activate_sending_specific_frame starting")

    # Create the test case core method that holds the main test steps.
    def test_sending_specific_frame(self):
        # Activate sending.
        start_transmission = self.legacy_frame(
            CHANNEL_NAME, FRAME_ID).start_transmission()
        
        sleep(0.5)

        # Deactivate sending.
        stop_transmission = self.legacy_frame(
            CHANNEL_NAME, FRAME_ID).stop_transmission()
        
        self.assertTrue(start_transmission, Severity.BLOCKER,
                        "Error: start_transmission is not working")
        
        self.assertTrue(stop_transmission, Severity.BLOCKER,
                        "Error: stop_transmission is not working")                

    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests.
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_activate_sending_specific_frame stopping")